-- [ja] 情報読み込み 
-- [ja] DrillCategory時とは違い、選択中のカテゴリのみ代入済み 
local drFile={};
local drInfo={};
drFile=getenv("drFile");
drInfo=getenv("drInfo");
local lvInfo={};
lvInfo=getenv("lvInfo");
local lvScore=getenv("lvScore");
local sys_sellevel=1

local difn=GetUserPref_Theme("UserDifficultyName");
local difc=GetUserPref_Theme("UserDifficultyColor");

local WHEEL_CENTER_X=SCREEN_CENTER_X-80;
local WHEEL_CENTER_Y=SCREEN_CENTER_Y+30;
local BANNER_CENTER_X=WHEEL_CENTER_X;
local BANNER_CENTER_Y=WHEEL_CENTER_Y-200;
local STATS_CENTER_X=WHEEL_CENTER_X-100;
local STATS_CENTER_Y=WHEEL_CENTER_Y+140;
local SCORE_CENTER_X=WHEEL_CENTER_X+80;
local SCORE_CENTER_Y=STATS_CENTER_Y;
local SONG_CENTER_X=math.max(SCREEN_CENTER_X+200,SCREEN_RIGHT-180);
local SONG_CENTER_Y=SCREEN_CENTER_Y-20;

local t=Def.ActorFrame{};
local t2=Def.ActorFrame{};
t2[#t2+1]=Def.ActorFrame{
	OnCommand=function(self)
		self:queuecommand("Set");
		self:addy(-SCREEN_HEIGHT);
		self:decelerate(_TT.S_IN);
		self:addy(SCREEN_HEIGHT);
	end;
	OffCommand=function(self)
		self:accelerate(_TT.S_OUT);
		self:addy(SCREEN_HEIGHT);
	end;
	SetRCommand=function(self)
		self:queuecommand("Set");
	end;
	SetCommand=function(self)
		self:finishtweening();
		if not getenv("sys_sellevel") then
			sys_sellevel=1;
		else
			sys_sellevel=getenv("sys_sellevel");
		end;
		if getenv("sys_move") then
			if getenv("sys_move")=="left" then
				self:queuecommand("MoveLeft");
			elseif getenv("sys_move")=="right" then
				self:queuecommand("MoveRight");
			end;
			setenv("sys_move",nil);
		end;
	end;
-- Wheel 
	LoadActor(THEME:GetPathG("_SelectMusic/white","wheelbg"))..{
		InitCommand=function(self)
			self:x(WHEEL_CENTER_X-20);
			self:y(WHEEL_CENTER_Y-20);
		end;
	};
	Def.Quad{
		SetCommand=function(self)
			self:zoomto(174,174);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
			if lvScore[""..sys_sellevel.."-DP"] then
				if lvScore[""..sys_sellevel.."-Clear"] then
					self:diffuse(Color("Yellow"));
				elseif lvScore[""..sys_sellevel.."-DP"]>0 then
					self:diffuse(Color("Black"));
				else
					self:diffuse(D3Color("Text"));
				end;
			else
				self:diffuse(D3Color("Text"));
			end;
		end;
		MoveLeftCommand=function(self)
			self:zoomto(124,124);
			self:x(WHEEL_CENTER_X+150);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(0.5);
			self:linear(0.2);
			self:zoomto(174,174);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(1);
		end;
		MoveRightCommand=function(self)
			self:zoomto(124,124);
			self:x(WHEEL_CENTER_X-150);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(0.5);
			self:linear(0.2);
			self:zoomto(174,174);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(1);
		end;
	};
	Def.Banner{
		SetCommand=function(self)
			self:Load(lvInfo[""..sys_sellevel.."-Jacket"]);
			self:scaletofit(-80,-80,80,80);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
		end;
		MoveLeftCommand=function(self)
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X+150);
			self:y(WHEEL_CENTER_Y);
			self:faderight(0.5);
			self:linear(0.2);
			self:scaletofit(-80,-80,80,80);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
			self:faderight(0);
		end;
		MoveRightCommand=function(self)
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X-150);
			self:y(WHEEL_CENTER_Y);
			self:fadeleft(0.5);
			self:linear(0.2);
			self:scaletofit(-80,-80,80,80);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
			self:fadeleft(0);
		end;
	};
	-- [ja] 左隣 
	Def.Banner{
		SetCommand=function(self)
			local s=sys_sellevel-1;
			if s<1 then s=drInfo["Level"]; end;
			self:Load(lvInfo[""..s.."-Jacket"]);
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X-150);
			self:y(WHEEL_CENTER_Y);
			self:fadeleft(0.5);
		end;
		MoveLeftCommand=function(self)
			self:scaletofit(-80,-80,80,80);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
			self:fadeleft(0);
			self:linear(0.2);
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X-150);
			self:y(WHEEL_CENTER_Y);
			self:fadeleft(0.5);
		end;
		MoveRightCommand=function(self)
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X-240);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(0);
			self:linear(0.2);
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X-150);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(1);
		end;
	};
	-- [ja] 右隣 
	Def.Banner{
		SetCommand=function(self)
			local s=sys_sellevel+1;
			if s>drInfo["Level"] then s=1; end;
			self:Load(lvInfo[""..s.."-Jacket"]);
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X+150);
			self:y(WHEEL_CENTER_Y);
			self:faderight(0.5);
		end;
		MoveLeftCommand=function(self)
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X+240);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(0);
			self:linear(0.2);
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X+150);
			self:y(WHEEL_CENTER_Y);
			self:diffusealpha(1);
		end;
		MoveRightCommand=function(self)
			self:scaletofit(-80,-80,80,80);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y);
			self:faderight(0);
			self:linear(0.2);
			self:scaletofit(-60,-60,60,60);
			self:x(WHEEL_CENTER_X+150);
			self:y(WHEEL_CENTER_Y);
			self:faderight(0.5);
		end;
	};
	LoadActor(THEME:GetPathG("EditMenu","Left"))..{
		InitCommand=function(self)
			self:x(WHEEL_CENTER_X-120);
			self:y(WHEEL_CENTER_Y);
		end;
	};
	LoadActor(THEME:GetPathG("EditMenu","Right"))..{
		InitCommand=function(self)
			self:x(WHEEL_CENTER_X+120);
			self:y(WHEEL_CENTER_Y);
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=cmd(maxwidth,300;);
		SetCommand=function(self)
			self:diffuse(Str2Color(lvInfo[""..sys_sellevel.."-Color"]));
			local c1=Str2Color(lvInfo[""..sys_sellevel.."-Color"])[1];
			local c2=Str2Color(lvInfo[""..sys_sellevel.."-Color"])[2];
			if tonumber(c2)<0.8 then
				self:strokecolor(Color("White"));
			else
				self:strokecolor(Color("Outline"));
			end;
			self:settext(lvInfo[""..sys_sellevel.."-Name"]);
			self:x(WHEEL_CENTER_X);
			self:y(WHEEL_CENTER_Y-118);
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=cmd(zoom,0.65;maxwidth,300/0.65;
			diffuse,D3Color("Text");strokecolor,Color("White");
			x,WHEEL_CENTER_X;y,WHEEL_CENTER_Y-98);
		SetCommand=function(self)
			self:settext(""..sys_sellevel.."/"..drInfo["Level"]);
		end;
	};
-- Banner 
	LoadActor(THEME:GetPathG("_SelectMusic/white","banner"))..{
		InitCommand=function(self)
			self:x(BANNER_CENTER_X);
			self:y(BANNER_CENTER_Y);
			self:zoomto(320,116);
		end;
	};
	Def.Sprite{
		Name="Banner";
		SetCommand=function(self)
			self:Load(lvInfo[""..sys_sellevel.."-Banner"]);
			self:scaletofit(-150,-48,150,48);
			self:x(BANNER_CENTER_X);
			self:y(BANNER_CENTER_Y);
		end;
	};
-- Stats 
	LoadActor(THEME:GetPathG("_SelectMusic/white","score"))..{
		InitCommand=function(self)
			self:x(STATS_CENTER_X);
			self:y(STATS_CENTER_Y);
		end;
	};
	--[[
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:x(STATS_CENTER_X-82);
			self:y(SCORE_CENTER_Y-9);
			self:zoom(0.75);
			self:settext("PlayerName :");
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(right);
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:x(STATS_CENTER_X+82);
			self:y(SCORE_CENTER_Y+7);
			self:zoom(0.75);
			local pname=PROFILEMAN:GetPlayerName(getenv("DrillPlayer"));
			if pname=="" then
				pname="MachineProfile";
			end;
			self:settext(string.format("% s",pname));
		end;
	};
	--]]
	LoadActor(THEME:GetPathG("_Drills/small drill","result"))..{
		InitCommand=function(self)
			self:x(STATS_CENTER_X);
			self:y(STATS_CENTER_Y);
			self:animate(false);
		end;
		SetCommand=function(self)
			if lvScore[""..sys_sellevel.."-DP"] then
				if lvScore[""..sys_sellevel.."-Clear"] then
					self:setstate(0);
				elseif lvScore[""..sys_sellevel.."-DP"]>0 then
					self:setstate(1);
				else
					self:setstate(2);
				end;
			else
				self:setstate(2);
			end;
		end;
	};
-- Score 
	LoadActor(THEME:GetPathG("_SelectMusic/white","score"))..{
		InitCommand=function(self)
			self:x(SCORE_CENTER_X);
			self:y(SCORE_CENTER_Y);
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:maxwidth(150/0.75);
			self:x(SCORE_CENTER_X-75);
			self:y(SCORE_CENTER_Y-3);
			self:zoom(0.75);
		end;
		SetCommand=function(self)
			self:settext("Score : "..string.format("%1.2f",lvScore[""..sys_sellevel.."-DP"]*100).."%\nClearRate : "
				..lvScore[""..sys_sellevel.."-ClearCnt"].."/"..lvScore[""..sys_sellevel.."-PlayCnt"]);
		end;
	};

-- SongList-BG 
	LoadActor(THEME:GetPathG("_SelectMusic/white","banner"))..{
		InitCommand=function(self)
			self:zoomto(220,360);
			self:x(SONG_CENTER_X);
			self:y(SONG_CENTER_Y);
		--	self:diffuse(Color("White"));
		--	self:diffusealpha(0.8);
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:horizalign(right);
			self:diffuse(D3Color("Red"));
			self:strokecolor(Color("White"));
			self:x(SONG_CENTER_X+100);
			self:y(SONG_CENTER_Y+190);
			self:zoom(0.75);
		end;
		SetCommand=function(self)
			local m=#lvInfo[""..sys_sellevel.."-Song"];
			if m==6 then
				self:settext("&MENUDOWN; And more (1 song)");
			elseif m>6 then
				self:settext("&MENUDOWN; And more ("..(m-5).." songs)");
			else
				self:settext("");
			end;
		end;
	};
	--[[
	LoadFont("Common Normal")..{
		Name="PlayerStats";
		OnCommand=function(self)
			self:horizalign(right);
			self:vertalign(top);
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:x(SCREEN_CENTER_X+300);
			self:y(SCREEN_CENTER_Y-160);
			self:queuecommand("Set");
		end;
		SetCommand=function(self)
			self:settext("Player : "..PROFILEMAN:GetPlayerName(getenv("DrillPlayer"))
				.."\n"..(lvScore[""..sys_sellevel.."-Clear"] and "CLEAR" or ((lvScore[""..sys_sellevel.."-DP"]>0) and "FAILED" or "NO DATA"))
				.."\nSCORE : "..string.format("%1.2f",lvScore[""..sys_sellevel.."-DP"]*100).."%"
				.."\nCLEAR/PLAY : "..lvScore[""..sys_sellevel.."-ClearCnt"].."/"..lvScore[""..sys_sellevel.."-PlayCnt"]);
		end;
	};
	--]]
};
-- SongList 
local sg;
local df;
local sm=1;
for i=1,5 do
t2[#t2+1]=Def.ActorFrame{
	-- [ja] 1曲当たりの縦スペースは64px 
	InitCommand=function(self)
		self:x(SONG_CENTER_X);
	end;
	OnCommand=function(self)
		self:queuecommand("Set");
		self:addy(-SCREEN_HEIGHT);
		self:decelerate(_TT.S_IN);
		self:addy(SCREEN_HEIGHT);
	end;
	OffCommand=function(self)
		self:accelerate(_TT.S_OUT);
		self:addy(SCREEN_HEIGHT);
	end;
	SetRCommand=function(self)
		self:queuecommand("Set");
	end;
	SetCommand=function(self)
		sg=nil;
		df=nil;
		sm=#lvInfo[""..sys_sellevel.."-Song"];
		if i<=sm then
			_,sg,df=GetDrillSong(lvInfo[""..sys_sellevel.."-Song"][i]);
		end;
		if sm<5 then
			self:y(SONG_CENTER_Y-230+i*80);
			self:addy((4-sm)*40+32);
		else
			self:y(SONG_CENTER_Y-210+i*70);
		end;
	end;
	--Def.Quad{
	LoadActor(THEME:GetPathG("_SelectMusic/white","banner"))..{
		OnCommand=function(self)
			self:zoomto(200,64);
			self:queuecommand("Set");
		end;
		SetCommand=function(self)
			if sg and df then
				self:diffuse(_DifficultyCOLOR2(difc,df));
			else
				self:diffuse(Color("Black"));
			end;
			self:diffusealpha(0.5);
			if i<=sm then
				self:visible(true);
			else
				self:visible(false);
			end;
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(left);
			self:diffuse(D3Color("Dark"));
			self:strokecolor(Color("White"));
			self:queuecommand("Set");
		end;
		SetCommand=function(self)
			self:x(-95);
			self:y(-24);
			self:zoom(0.6);
			if sg then
				self:settext("Stage"..i);
			else
				if i<=sm then
					self:settext("Stage"..i.." <ERROR>");
				else
					self:settext("");
				end;
			end;
		end;
	};
	Def.Banner{
		OnCommand=function(self)
			self:horizalign(left);
			self:queuecommand("Set");
		end;
		SetCommand=function(self)
			if sg then
				if sg:HasBanner() then
					self:LoadFromCachedBanner(sg:GetBannerPath());
				else
					self:Load(THEME:GetPathG("Common fallback","banner"));
				end;
			else
				if i<=sm then
					self:Load(THEME:GetPathG("_Drills/banner","error"));
				else
					self:Load(THEME:GetPathG("","_blank"));
				end;
			end;
			self:scaletofit(-48,-15,48,15);
			self:x(-95);
			self:y(0);
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(left);
			self:maxwidth(190/0.75);
			self:queuecommand("Set");
		end;
		SetCommand=function(self)
			self:x(-95);
			self:y(20);
			self:zoom(0.75);
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			if sg then
				self:settext(sg:GetDisplayFullTitle());
			else
				if i<=sm then
					self:diffuse(D3Color("Red"));
					self:strokecolor(Color("Black"));
					self:settext("Song not found.");
				else
					self:settext("");
				end;
			end;
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(right);
			self:maxwidth(190/0.75);
			self:queuecommand("Set");
		end;
		SetCommand=function(self)
			self:x(95);
			self:y(-20);
			self:zoom(0.6);
			if df then
				self:diffuse(_DifficultyCOLOR(df));
				self:strokecolor(Color("White"));
				if sg then
					self:settext(string.upper(_DifficultyNAME2(difn,df)));
				else
					self:settext("");
				end;
			else
				self:settext("");
			end;
		end;
	};
	LoadFont("Common Normal")..{
		OnCommand=function(self)
			self:horizalign(right);
			self:maxwidth(190);
			self:queuecommand("Set");
		end;
		SetCommand=function(self)
			self:x(95);
			self:y(-2);
			if df then
				self:diffuse(_DifficultyCOLOR(df));
				self:strokecolor(Color("White"));
				if sg then
					local stt=GAMESTATE:GetCurrentStyle():GetStepsType();
					if stt then
						local st=sg:GetOneSteps(stt,df);
						self:settext(st:GetMeter());
					else
						self:settext("");
					end;
				else
					self:settext("");
				end;
			else
				self:settext("");
			end;
		end;
	};
};
end;

-- Header/Footer 
t2[#t2+1]=Def.ActorFrame{
	LoadActor(THEME:GetPathG("ScreenWithMenuElements","header"))..{
		InitCommand=function(self)
			self:x(SCREEN_LEFT);
			self:y(SCREEN_CENTER_Y-15);
		end;
	};
};
t2[#t2+1]=Def.ActorFrame{
	OnCommand=function(self)
		self:addy(-SCREEN_HEIGHT);
		self:decelerate(_TT.S_IN);
		self:addy(SCREEN_HEIGHT);
	end;
	OffCommand=function(self)
		self:accelerate(_TT.S_OUT);
		self:addy(SCREEN_HEIGHT);
	end;
	LoadActor(THEME:GetPathG("ScreenWithMenuElements","footer"))..{
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X);
			self:y(SCREEN_BOTTOM);
		end;
	};
	LoadActor(THEME:GetPathG("ScreenWithMenuElements","help"))..{
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X);
			self:y(SCREEN_BOTTOM-16);
			(cmd(SetSecsBetweenSwitches,4;zoom,0.675;maxwidth,(SCREEN_WIDTH-300)/0.675;shadowlength,1;strokecolor,Color("Black");draworder,105;zoomy,0;zoom,1*0.675;linear,0.175))(self);
		end;
	};
};

local oTime=0;
local nTime=0;
local wait=1.0/60;
local sys_offcommand=false;
local function update(self,dt)
	nTime=nTime+dt;
	-- [ja] 1回分の処理 
	if nTime-oTime>wait then
		if getenv("sys_selected") and not sys_offcommand then
			sys_offcommand=true;
			self:queuecommand("Off");
		end;
		if getenv("sys_move") then
			self:queuecommand("SetR");
		end;
		oTime=oTime+wait;
	end;
end;
t2.InitCommand=cmd(SetUpdateFunction,update);
t[#t+1]=t2;
return t;